--[[----------------------------------------------------------------------------
	Copyright 2008 João Liborio Cardoso
	All rights reserved
	
	Bongos Tooltip is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
	Bongos Tooltip is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License (<http://www.gnu.org/licenses/>) for more details.
---------------------------------------------------------------------------]]--

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local AutoBongos = LibStub('AutoBongos-1.0')
local Tooltip = Bongos:NewModule('Tooltip')


--[[ Bongos Bar ]]--

function Tooltip:Load()
	local defaults = {
		point = "BOTTOMRIGHT",
		y = 238,
		x = -13,
	}
	
	self.bar, isNew = AutoBongos:CreateBar('tooltip', defaults, nil, 'TOOLTIP')
	if isNew then
		self.LoadBar(self.bar)
	end
end

function Tooltip:Unload()
	self.bar:Destroy()
end

function Tooltip:LoadBar()
	for k,v in pairs(Tooltip) do self[k] = v end
	GameTooltip:SetParent(self)
	GameTooltip:SetFrameStrata('TOOLTIP')
	
	hooksecurefunc('GameTooltip_SetDefaultAnchor', function(...)
		self:Anchor(...)
	end)
end


--[[ Tooltip ]]--

function Tooltip:Anchor(tooltip, parent)
	tooltip:SetOwner(parent, "ANCHOR_NONE")
	tooltip:ClearAllPoints(self)
	tooltip:SetPoint('TOP', self)
	tooltip.default = 1
	
	self.stopDelay = 0.2
	self.tooltip = tooltip
	self.tooltipParent = parent
	self:SetScript('OnUpdate', self.OnUpdate)
end

function Tooltip:OnUpdate(elapsed)
	if self.stopDelay > 0 then
		self.stopDelay = self.stopDelay - elapsed
		self:UpdateSize()
	end
	
	if self.tooltip:GetOwner() ~= self.tooltipParent then
		self.tooltip = nil
		self:SetScript('OnUpdate', nil)
		self:UpdateSize()
	end
end

function Tooltip:UpdateSize()
	local width, height
	if self.tooltip then
		width = self.tooltip:GetWidth()
		height = self.tooltip:GetHeight() + ( self.tooltip:GetUnit() and 10 or 0 )
	else
		if Bongos:IsLocked() then
			width, height = 0.1, 0.1
		else
			width, height = 200, 80
		end
	end
	self:SetWidth(width)
	self:SetHeight(height)
end